<?php

namespace App\Exports;

use App\Models\Petani;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class PetaniExport implements FromCollection, WithHeadings, WithMapping, WithColumnFormatting, ShouldAutoSize
{
    public function collection()
    {
        return Petani::with(['desa', 'poktan', 'kios'])->get();
    }

    public function headings(): array
    {
        return [
            'Nama Petani',
            'No KTP',
            'Nama Ibu Kandung',
            'Kode Desa',
            'ID Poktan',
            'Kode Kios',
            'Subsektor',
            'Komoditas',
            'Luas Lahan',
            'Status',
            'Tanggal Dibuat',
            'Tanggal Diperbarui',
        ];
    }

    public function map($row): array
    {
        $ktp = "'".(string) $row->no_ktp;

        return [
            $row->nama ?? $row->nama_penyuluh,
            $ktp,
            $row->nama_ibu_kandung,
            $row->desa ? (string) $row->desa->kode_desa : '',
            $row->poktan ? (string) $row->poktan->id_poktan : '',
            $row->kios ? (string) $row->kios->kode_kios : '',
            $row->subsektor,
            $row->komoditas,
            is_null($row->luas_lahan) ? null : (float) $row->luas_lahan,
            $row->status,
            optional($row->created_at)->format('Y-m-d H:i:s'),
            optional($row->updated_at)->format('Y-m-d H:i:s'),
        ];
    }

    public function columnFormats(): array
    {
        return [
            'B' => NumberFormat::FORMAT_TEXT,
            'D' => NumberFormat::FORMAT_TEXT,
            'E' => NumberFormat::FORMAT_TEXT,
            'F' => NumberFormat::FORMAT_TEXT,
            'I' => '#,##0.00',
            'K' => 'yyyy-mm-dd hh:mm:ss',
            'L' => 'yyyy-mm-dd hh:mm:ss',
        ];
    }
}
