<?php

namespace App\Http\Controllers;

use App\Models\Desa;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

class DesaController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $desas = Desa::paginate(10);
        return view('desa.index', compact('desas'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('desa.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'kode_desa' => 'required|string|max:20|unique:desas,kode_desa',
            'nama_desa' => 'required|string|max:100',
            'kode_kec' => 'required|string|max:20',
        ]);

        if ($validator->fails()) {
            return redirect()->route('desa.create')
                ->withErrors($validator)
                ->withInput();
        }

        Desa::create($request->all());

        return redirect()->route('desa.index')
            ->with('success', 'Desa berhasil ditambahkan.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $desa = Desa::findOrFail($id);
        return view('desa.show', compact('desa'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $desa = Desa::findOrFail($id);
        return view('desa.edit', compact('desa'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $desa = Desa::findOrFail($id);
        
        $validator = Validator::make($request->all(), [
            'kode_desa' => ['required', 'string', 'max:20', Rule::unique('desas')->ignore($id, 'kode_desa')],
            'nama_desa' => 'required|string|max:100',
            'kode_kec' => 'required|string|max:20',
        ]);

        if ($validator->fails()) {
            return redirect()->route('desa.edit', $id)
                ->withErrors($validator)
                ->withInput();
        }

        $desa->update($request->all());

        return redirect()->route('desa.index')
            ->with('success', 'Desa berhasil diperbarui.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $desa = Desa::findOrFail($id);
        $desa->delete();

        return redirect()->route('desa.index')
            ->with('success', 'Desa berhasil dihapus.');
    }
}
