<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * Middleware ForceHttps
 * 
 * Memaksa semua koneksi menggunakan HTTPS di environment production
 * untuk melindungi data sensitif dari sniffing dan MITM attacks
 */
class ForceHttps
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Hanya enforce HTTPS di production
        if (!app()->environment('local', 'development')) {
            // Cek apakah request sudah menggunakan HTTPS
            if (!$request->secure()) {
                // Redirect ke HTTPS version dengan status code 301 (Permanent)
                return redirect()->secure(
                    $request->getRequestUri(),
                    301
                );
            }
        }

        return $next($request);
    }
}

