<?php

namespace App\Imports;

use App\Models\Petani;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\SkipsOnError;
use Maatwebsite\Excel\Concerns\SkipsErrors;
use Illuminate\Support\Facades\Auth;

class PetaniImport implements ToModel, WithHeadingRow, WithValidation, SkipsOnError
{
    use SkipsErrors;
    
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        // Validasi status sebelum membuat model
        $status = $row['status'] ?? 'belum_terinput';
        if (!in_array($status, ['belum_terinput', 'sudah_terinput'])) {
            $status = 'belum_terinput'; // Default ke belum_terinput jika tidak valid
        }
        
        return new Petani([
            'nama_penyuluh' => $row['nama_penyuluh'],
            'no_ktp' => $row['no_ktp'],
            'nama_ibu_kandung' => $row['nama_ibu_kandung'],
            'kode_desa' => $row['kode_desa'],
            'id_poktan' => $row['id_poktan'],
            'kode_kios' => $row['kode_kios'],
            'subsektor' => !empty($row['subsektor']) ? $row['subsektor'] : null,
            'komoditas' => !empty($row['komoditas']) ? $row['komoditas'] : null,
            'luas_lahan' => $row['luas_lahan'] ?? 0.01,
            'status' => $status,
            'created_by' => Auth::id(),
            'updated_by' => Auth::id(),
        ]);
    }
    
    /**
     * @return array
     */
    public function rules(): array
    {
        return [
            'nama_penyuluh' => 'required|string|max:100',
            'no_ktp' => 'required|string|size:16|unique:petanis,no_ktp',
            'nama_ibu_kandung' => 'required|string|max:100',
            'kode_desa' => 'required|string|exists:desas,kode_desa',
            'id_poktan' => 'required|string|exists:poktans,id_poktan',
            'kode_kios' => 'required|string|exists:kios,kode_kios',
            'subsektor' => 'nullable|in:tanaman_pangan,hortikultura,perkebunan,peternakan',
            'komoditas' => 'nullable|string|max:100',
            'luas_lahan' => 'nullable|numeric|min:0.01',
            'status' => 'nullable|in:belum_terinput,sudah_terinput',
        ];
    }
}