<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Desa extends Model
{
    use HasFactory;
    
    protected $table = 'desas';
    protected $primaryKey = 'kode_desa';
    protected $keyType = 'string';
    public $incrementing = false;
    
    protected $fillable = [
        'kode_desa',
        'nama_desa',
        'kode_kec',
    ];
    
    public function poktans()
    {
        return $this->hasMany(Poktan::class, 'kode_desa', 'kode_desa');
    }
    
    public function petanis()
    {
        return $this->hasMany(Petani::class, 'kode_desa', 'kode_desa');
    }
}