<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Poktan extends Model
{
    use HasFactory;
    
    protected $table = 'poktans';
    protected $primaryKey = 'id_poktan';
    protected $keyType = 'string';
    public $incrementing = false;
    
    protected $fillable = [
        'id_poktan',
        'nama_poktan',
        'kode_desa',
    ];
    
    public function desa()
    {
        return $this->belongsTo(Desa::class, 'kode_desa', 'kode_desa');
    }
    
    public function petanis()
    {
        return $this->hasMany(Petani::class, 'id_poktan', 'id_poktan');
    }
}