<?php

namespace App\Repositories;

use App\Models\Petani;
use Illuminate\Database\Eloquent\Collection;

/**
 * Interface PetaniRepositoryInterface
 * 
 * Interface untuk repository petani yang mendefinisikan operasi CRUD
 */
interface PetaniRepositoryInterface
{
    /**
     * Mendapatkan semua data petani
     * 
     * @return Collection
     */
    public function getAll(): Collection;
    
    /**
     * Mendapatkan data petani berdasarkan ID
     * 
     * @param string $id
     * @return Petani|null
     */
    public function findById(string $id): ?Petani;
    
    /**
     * Mendapatkan data petani berdasarkan nomor KTP
     * 
     * @param string $noKtp
     * @return Petani|null
     */
    public function findByNoKtp(string $noKtp): ?Petani;
    
    /**
     * Membuat data petani baru
     * 
     * @param array $data
     * @return Petani
     */
    public function create(array $data): Petani;
    
    /**
     * Mengupdate data petani
     * 
     * @param string $id
     * @param array $data
     * @return Petani
     */
    public function update(string $id, array $data): Petani;
    
    /**
     * Menghapus data petani
     * 
     * @param string $id
     * @return bool
     */
    public function delete(string $id): bool;
    
    /**
     * Mendapatkan data petani berdasarkan desa
     * 
     * @param string $kodeDesa
     * @return Collection
     */
    public function getByDesa(string $kodeDesa): Collection;
    
    /**
     * Mendapatkan data petani berdasarkan kelompok tani
     * 
     * @param string $idPoktan
     * @return Collection
     */
    public function getByPoktan(string $idPoktan): Collection;
    
    /**
     * Mendapatkan data petani berdasarkan kios
     * 
     * @param string $kodeKios
     * @return Collection
     */
    public function getByKios(string $kodeKios): Collection;
}