<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Gunakan raw SQL untuk mengubah kolom ENUM dan VARCHAR menjadi nullable
        DB::statement("ALTER TABLE petanis MODIFY COLUMN subsektor ENUM('tanaman_pangan', 'hortikultura', 'perkebunan', 'peternakan') NULL");
        DB::statement("ALTER TABLE petanis MODIFY COLUMN komoditas VARCHAR(100) NULL");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Kembalikan kolom menjadi NOT NULL
        DB::statement("ALTER TABLE petanis MODIFY COLUMN subsektor ENUM('tanaman_pangan', 'hortikultura', 'perkebunan', 'peternakan') NOT NULL");
        DB::statement("ALTER TABLE petanis MODIFY COLUMN komoditas VARCHAR(100) NOT NULL");
    }
};
