<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('petanis', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('nama_penyuluh', 100);
            $table->string('no_ktp', 16)->unique();
            $table->string('nama_ibu_kandung', 100);
            $table->string('kode_desa');
            $table->string('id_poktan');
            $table->string('kode_kios');
            $table->enum('subsektor', ['tanaman_pangan', 'hortikultura', 'perkebunan', 'peternakan']);
            $table->string('komoditas', 100)->index();
            $table->decimal('luas_lahan', 8, 2);
            $table->enum('status', ['belum_terinput', 'sudah_terinput'])->default('belum_terinput');
            $table->uuid('created_by')->nullable();
            $table->uuid('updated_by')->nullable();
            $table->timestamps();
            $table->softDeletes();
            
            $table->foreign('kode_desa')->references('kode_desa')->on('desas');
            $table->foreign('id_poktan')->references('id_poktan')->on('poktans');
            $table->foreign('kode_kios')->references('kode_kios')->on('kios');
            
            $table->index('kode_desa');
            $table->index('id_poktan');
            $table->index('kode_kios');
            $table->index('subsektor');
            $table->index('status');
            $table->unique(['no_ktp', 'id_poktan']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('petanis');
    }
};
