# Panduan Import & Export Data Kelompok Tani

## Deskripsi
Fitur ini memungkinkan pengguna untuk melakukan export data kelompok tani ke file Excel dan import data kelompok tani dari file Excel secara massal.

## Fitur yang Tersedia

### 1. Export Data Kelompok Tani
Export semua data kelompok tani yang ada di sistem ke dalam file Excel.

**Cara Menggunakan:**
1. Buka halaman **Kelompok Tani**
2. Klik tombol **Export Excel**
3. File akan otomatis terdownload dengan nama `daftar-kelompok-tani-YYYY-MM-DD.xlsx`

**Kolom yang di-export:**
- ID Poktan
- Nama Poktan
- Kode Desa
- Nama Desa
- Tanggal Dibuat
- Tanggal Diperbarui

### 2. Download Template Import
Download template Excel kosong dengan format yang sudah sesuai untuk import data.

**Cara Menggunakan:**
1. Buka halaman **Kelompok Tani**
2. Klik tombol **Download Template**
3. File template akan terdownload dengan nama `template-kelompok-tani.xlsx`
4. Template sudah dilengkapi dengan:
   - Header kolom yang sudah terformat
   - Contoh data di baris ke-2 (hapus sebelum import)
   - Instruksi lengkap dalam comment di cell A1

### 3. Import Data Kelompok Tani
Import data kelompok tani secara massal dari file Excel.

**Cara Menggunakan:**
1. Download template terlebih dahulu (lihat poin 2)
2. Isi data sesuai kolom yang tersedia:
   - **ID Poktan**: Kode unik kelompok tani (maksimal 20 karakter)
   - **Nama Poktan**: Nama kelompok tani (maksimal 100 karakter)
   - **Kode Desa**: Kode desa yang sudah terdaftar di sistem
3. Hapus baris contoh data
4. Simpan file dalam format .xlsx atau .xls
5. Kembali ke halaman **Kelompok Tani**
6. Klik tombol **Import Excel**
7. Pilih file yang sudah diisi
8. Klik tombol **Import**
9. Tunggu proses import selesai

## Validasi Data

Sistem akan melakukan validasi untuk setiap baris data yang diimport:

### Kolom Wajib:
- **ID Poktan**: Wajib diisi, maksimal 20 karakter
- **Nama Poktan**: Wajib diisi, maksimal 100 karakter
- **Kode Desa**: Wajib diisi dan harus sudah terdaftar di sistem

### Aturan Khusus:
- Jika ID Poktan sudah ada di sistem, data akan di-update
- Jika ID Poktan belum ada, data akan ditambahkan sebagai data baru
- Kode Desa harus valid dan sudah terdaftar di sistem

## Handling Error

### Jika Import Gagal:
- Sistem akan menampilkan pesan error spesifik
- Error akan menunjukkan baris yang bermasalah
- Data yang valid tetap akan diimport, yang error akan dilewati

### Pesan Error Umum:
- **"File tidak valid"**: Format file bukan .xlsx atau .xls, atau ukuran file lebih dari 5MB
- **"Kode Desa tidak valid"**: Kode desa yang diinput tidak terdaftar di sistem
- **"ID Poktan wajib diisi"**: Kolom ID Poktan kosong
- **"Nama Poktan wajib diisi"**: Kolom Nama Poktan kosong

## Tips & Trik

1. **Gunakan Template**: Selalu gunakan template yang disediakan untuk memastikan format data sudah benar
2. **Cek Kode Desa**: Pastikan kode desa yang akan diinput sudah terdaftar di sistem terlebih dahulu
3. **Backup Data**: Lakukan export data lama sebelum melakukan import data baru
4. **Test dengan Data Sedikit**: Untuk import pertama kali, coba dengan data sedikit untuk memastikan formatnya sudah benar
5. **Baca Instruksi**: Baca instruksi yang ada di comment cell A1 pada template

## Batasan Sistem

- **Ukuran File**: Maksimal 5MB
- **Format File**: Hanya .xlsx dan .xls
- **Rate Limiting**: 
  - Export: Maksimal 5 request per menit
  - Import: Maksimal 3 request per menit
  - Download Template: Maksimal 10 request per menit

## FAQ

### Q: Apakah data lama akan terhapus saat import?
**A:** Tidak. Sistem akan mengupdate data jika ID Poktan sudah ada, atau menambahkan data baru jika ID Poktan belum ada.

### Q: Bagaimana jika ada data yang error saat import?
**A:** Data yang valid akan tetap diimport, dan sistem akan memberikan laporan error untuk baris yang bermasalah.

### Q: Apakah bisa import data dengan kode desa yang belum terdaftar?
**A:** Tidak. Kode desa harus sudah terdaftar di sistem terlebih dahulu. Silakan tambahkan data desa terlebih dahulu sebelum melakukan import kelompok tani.

### Q: Berapa maksimal data yang bisa diimport sekaligus?
**A:** Tidak ada batasan jumlah baris, namun ukuran file maksimal 5MB. Untuk performa optimal, disarankan import maksimal 1000 baris per file.

## Troubleshooting

### Import gagal terus meskipun format sudah benar
1. Pastikan tidak ada spasi berlebih di awal atau akhir data
2. Pastikan kode desa valid dan sudah terdaftar
3. Coba import dengan data lebih sedikit untuk testing
4. Periksa apakah ada karakter khusus yang tidak didukung

### File template tidak bisa dibuka
1. Pastikan Microsoft Excel atau aplikasi spreadsheet lainnya terinstall
2. Coba download ulang template
3. Gunakan aplikasi alternatif seperti Google Sheets atau LibreOffice Calc

## Support
Jika mengalami kendala, silakan hubungi administrator sistem.

