// Custom JavaScript untuk membuat aplikasi lebih interaktif

// Fungsi untuk animasi elemen saat halaman dimuat
document.addEventListener('DOMContentLoaded', function() {
    // Tambahkan kelas animasi ke elemen-elemen utama
    const mainElements = document.querySelectorAll('.card, .bg-white, table, form');
    mainElements.forEach((element, index) => {
        setTimeout(() => {
            element.classList.add('fade-in');
        }, index * 100);
    });

    // Tambahkan efek hover pada baris tabel
    const tableRows = document.querySelectorAll('tbody tr');
    tableRows.forEach(row => {
        row.addEventListener('mouseenter', function() {
            this.style.transform = 'scale(1.01)';
            this.style.transition = 'all 0.2s ease';
        });
        row.addEventListener('mouseleave', function() {
            this.style.transform = 'scale(1)';
        });
    });

    // Tambahkan efek klik pada tombol
    const buttons = document.querySelectorAll('button, .btn, [type="submit"]');
    buttons.forEach(button => {
        button.addEventListener('click', function() {
            this.classList.add('clicked');
            setTimeout(() => {
                this.classList.remove('clicked');
            }, 200);
        });
    });

    // Fungsi pencarian real-time untuk tabel
    const searchInputs = document.querySelectorAll('input[id$="searchInput"]');
    searchInputs.forEach(input => {
        input.addEventListener('keyup', function() {
            const searchTerm = this.value.toLowerCase();
            const tableId = this.id.replace('searchInput', 'Table');
            const table = document.getElementById(tableId);
            
            if (table) {
                const rows = table.querySelectorAll('tbody tr');
                
                rows.forEach(row => {
                    const text = row.textContent.toLowerCase();
                    if (text.includes(searchTerm)) {
                        row.style.display = '';
                    } else {
                        row.style.display = 'none';
                    }
                });
            }
        });
    });

    // Konfirmasi hapus dengan animasi
    window.confirmDelete = function(id) {
        if (confirm('Apakah Anda yakin ingin menghapus item ini?')) {
            const form = document.getElementById('delete-form-' + id);
            if (form) {
                const row = form.closest('tr');
                row.style.transition = 'all 0.5s ease';
                row.style.opacity = '0';
                row.style.transform = 'translateX(20px)';
                
                setTimeout(() => {
                    form.submit();
                }, 500);
            }
        }
    };

    // Notifikasi sukses dengan animasi fade out
    const alerts = document.querySelectorAll('.bg-green-100');
    alerts.forEach(alert => {
        setTimeout(() => {
            alert.style.transition = 'opacity 1s ease';
            alert.style.opacity = '0';
            setTimeout(() => {
                alert.style.display = 'none';
            }, 1000);
        }, 5000);
    });
});