# Style Guide - Aplikasi RDKK Trae

Dokumentasi ini berisi panduan desain untuk pengembangan berkelanjutan aplikasi RDKK Trae.

## Sistem Warna

Aplikasi menggunakan skema warna profesional yang konsisten:

```css
--primary: #3b82f6;     /* Biru */
--secondary: #10b981;   /* Hijau */
--danger: #ef4444;      /* Merah */
--warning: #f59e0b;     /* Oranye */
--info: #3b82f6;        /* Biru */
--success: #10b981;     /* Hijau */
```

Setiap warna memiliki variasi terang dan gelap:
- `--primary-dark`, `--primary-light`
- `--secondary-dark`, `--secondary-light`
- dst.

## Tipografi

Aplikasi menggunakan font system-ui yang jelas dan mudah dibaca:

```css
--font-sans: ui-sans-serif, system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, "Noto Sans", sans-serif;
--font-serif: ui-serif, Georgia, Cambria, "Times New Roman", Times, serif;
--font-mono: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;
```

## Spacing

Sistem spacing konsisten untuk margin dan padding:

```css
--spacing-0: 0;
--spacing-1: 0.25rem;  /* 4px */
--spacing-2: 0.5rem;   /* 8px */
--spacing-3: 0.75rem;  /* 12px */
--spacing-4: 1rem;     /* 16px */
--spacing-5: 1.25rem;  /* 20px */
--spacing-6: 1.5rem;   /* 24px */
--spacing-8: 2rem;     /* 32px */
--spacing-10: 2.5rem;  /* 40px */
--spacing-12: 3rem;    /* 48px */
--spacing-16: 4rem;    /* 64px */
--spacing-20: 5rem;    /* 80px */
--spacing-24: 6rem;    /* 96px */
```

## Shadows

Sistem bayangan untuk memberikan kedalaman:

```css
--shadow-sm: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
--shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
--shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
--shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
--shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
```

## Border Radius

Sistem radius sudut:

```css
--radius-none: 0;
--radius-sm: 0.125rem;  /* 2px */
--radius: 0.25rem;      /* 4px */
--radius-md: 0.375rem;  /* 6px */
--radius-lg: 0.5rem;    /* 8px */
--radius-xl: 0.75rem;   /* 12px */
--radius-2xl: 1rem;     /* 16px */
--radius-3xl: 1.5rem;   /* 24px */
--radius-full: 9999px;  /* Lingkaran */
```

## Komponen

### Cards

Gunakan `.card` untuk membuat container dengan bayangan dan sudut membulat:

```html
<div class="card">
  <div class="card-header">Judul Card</div>
  <div class="card-body">Konten card</div>
  <div class="card-footer">Footer card</div>
</div>
```

### Buttons

Tersedia beberapa variasi tombol:

```html
<button class="btn btn-primary">Tombol Primary</button>
<button class="btn btn-secondary">Tombol Secondary</button>
<button class="btn btn-danger">Tombol Danger</button>
<button class="btn btn-warning">Tombol Warning</button>
<button class="btn btn-outline">Tombol Outline</button>
```

Ukuran tombol:
```html
<button class="btn btn-primary btn-sm">Tombol Kecil</button>
<button class="btn btn-primary">Tombol Normal</button>
<button class="btn btn-primary btn-lg">Tombol Besar</button>
```

### Forms

Struktur form:

```html
<div class="form-group">
  <label for="nama" class="form-label">Nama</label>
  <input type="text" id="nama" class="form-control" placeholder="Masukkan nama">
  <div class="form-text">Teks bantuan di bawah input</div>
  <div class="form-error">Pesan error</div>
</div>
```

Select:
```html
<div class="form-group">
  <label for="pilihan" class="form-label">Pilihan</label>
  <select id="pilihan" class="form-select">
    <option>Pilihan 1</option>
    <option>Pilihan 2</option>
  </select>
</div>
```

### Tables

Struktur tabel:

```html
<div class="table-container">
  <table class="table">
    <thead>
      <tr>
        <th>Kolom 1</th>
        <th>Kolom 2</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td>Data 1</td>
        <td>Data 2</td>
      </tr>
    </tbody>
  </table>
</div>
```

Variasi tabel:
```html
<table class="table table-striped">
  <!-- Konten tabel -->
</table>
```

### Badges

```html
<span class="badge badge-primary">Primary</span>
<span class="badge badge-secondary">Secondary</span>
<span class="badge badge-success">Success</span>
<span class="badge badge-danger">Danger</span>
<span class="badge badge-warning">Warning</span>
<span class="badge badge-info">Info</span>
```

### Breadcrumbs

```html
<nav class="breadcrumb" aria-label="breadcrumb">
  <ol class="flex text-sm">
    <li class="breadcrumb-item"><a href="#">Home</a></li>
    <li class="breadcrumb-item"><a href="#">Library</a></li>
    <li class="breadcrumb-item active" aria-current="page">Data</li>
  </ol>
</nav>
```

### Modals

```html
<div id="myModal" class="modal-backdrop hidden">
  <div class="modal-content">
    <div class="modal-header">
      <h3 class="text-lg font-bold">Judul Modal</h3>
      <button type="button" id="closeModalX" class="text-gray-500 hover:text-gray-700">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
        </svg>
      </button>
    </div>
    <div class="modal-body">
      Konten modal
    </div>
    <div class="modal-footer">
      <button type="button" id="closeModal" class="btn btn-outline">Batal</button>
      <button type="button" id="confirmAction" class="btn btn-primary">Konfirmasi</button>
    </div>
  </div>
</div>
```

JavaScript untuk modal:
```javascript
document.addEventListener('DOMContentLoaded', function() {
  const openModalBtn = document.getElementById('openModal');
  const modal = document.getElementById('myModal');
  const closeModal = document.getElementById('closeModal');
  const closeModalX = document.getElementById('closeModalX');
  
  openModalBtn.addEventListener('click', function() {
    modal.classList.remove('hidden');
    modal.classList.add('flex');
  });
  
  closeModal.addEventListener('click', function() {
    modal.classList.add('hidden');
    modal.classList.remove('flex');
  });
  
  closeModalX.addEventListener('click', function() {
    modal.classList.add('hidden');
    modal.classList.remove('flex');
  });
});
```

## Loading States

```html
<div class="loading-container">
  <div class="loading"></div>
</div>
```

Overlay loading:
```html
<div class="loading-overlay">
  <div class="loading"></div>
</div>
```

## Empty States

```html
<div class="empty-state">
  <div class="empty-state-icon">
    <svg xmlns="http://www.w3.org/2000/svg" class="h-16 w-16" fill="none" viewBox="0 0 24 24" stroke="currentColor">
      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4" />
    </svg>
  </div>
  <h3 class="text-lg font-medium text-gray-900">Tidak ada data</h3>
  <p class="empty-state-text">Belum ada data yang tersedia. Silakan tambahkan data baru.</p>
  <button class="btn btn-primary">Tambah Data</button>
</div>
```

## Utility Classes

### Text Colors
```
.text-primary, .text-secondary, .text-success, .text-danger, .text-warning, .text-info
```

### Background Colors
```
.bg-primary, .bg-secondary, .bg-success, .bg-danger, .bg-warning, .bg-info, .bg-light, .bg-dark
```

### Shadows
```
.shadow-sm, .shadow, .shadow-md, .shadow-lg, .shadow-xl
```

### Border Radius
```
.rounded-none, .rounded-sm, .rounded, .rounded-md, .rounded-lg, .rounded-xl, .rounded-2xl, .rounded-3xl, .rounded-full
```

## Animasi

Tersedia beberapa kelas animasi:

```
.fade-in - Animasi fade in
.slide-in-up - Animasi slide dari bawah ke atas
.pulse - Animasi pulse (berkedip)
```

## Aksesibilitas

Aplikasi ini dirancang dengan memperhatikan aksesibilitas:

1. Kontras warna yang memadai
2. Fokus yang jelas pada elemen interaktif
3. Teks alternatif untuk gambar
4. Struktur heading yang tepat
5. Label yang jelas untuk form
6. Keyboard navigation yang baik

Gunakan kelas `.sr-only` untuk teks yang hanya terlihat oleh screen reader:

```html
<span class="sr-only">Teks untuk screen reader</span>
```

## Responsif

Aplikasi menggunakan sistem grid responsif dengan breakpoint:

- Small (sm): 640px
- Medium (md): 768px
- Large (lg): 1024px
- Extra Large (xl): 1280px
- 2 Extra Large (2xl): 1536px

Contoh penggunaan:

```html
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
  <!-- Konten -->
</div>
```

## Praktik Terbaik

1. Gunakan komponen yang konsisten
2. Ikuti sistem warna yang telah ditentukan
3. Perhatikan spacing yang konsisten
4. Gunakan animasi dengan bijak
5. Pastikan semua elemen interaktif dapat diakses dengan keyboard
6. Uji aplikasi pada berbagai ukuran layar
7. Optimasi performa dengan mengurangi JavaScript yang tidak perlu
8. Gunakan lazy loading untuk gambar
9. Minifikasi CSS dan JavaScript untuk produksi