<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Edit Desa') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <form method="POST" action="{{ route('desa.update', $desa->kode_desa) }}">
                        @csrf
                        @method('PUT')

                        <div class="mb-4">
                            <x-input-label for="kode_desa" :value="__('Kode Desa')" />
                            <x-text-input id="kode_desa" class="block mt-1 w-full bg-gray-100" type="text" name="kode_desa" :value="$desa->kode_desa" required readonly />
                            <x-input-error :messages="$errors->get('kode_desa')" class="mt-2" />
                        </div>

                        <div class="mb-4">
                            <x-input-label for="nama_desa" :value="__('Nama Desa')" />
                            <x-text-input id="nama_desa" class="block mt-1 w-full" type="text" name="nama_desa" :value="$desa->nama_desa" required />
                            <x-input-error :messages="$errors->get('nama_desa')" class="mt-2" />
                        </div>

                        <div class="mb-4">
                            <x-input-label for="kode_kec" :value="__('Kode Kecamatan')" />
                            <x-text-input id="kode_kec" class="block mt-1 w-full" type="text" name="kode_kec" :value="$desa->kode_kec" required />
                            <x-input-error :messages="$errors->get('kode_kec')" class="mt-2" />
                        </div>

                        <div class="flex items-center justify-end mt-4">
                            <a href="{{ route('desa.index') }}" class="inline-flex items-center px-4 py-2 bg-gray-300 border border-transparent rounded-md font-semibold text-xs text-gray-700 uppercase tracking-widest hover:bg-gray-400 focus:bg-gray-400 active:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2 transition ease-in-out duration-150 mr-2">
                                Batal
                            </a>
                            <x-primary-button>
                                {{ __('Simpan') }}
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>