<x-app-layout>
    <link rel="stylesheet" href="{{ asset('css/modern-design.css') }}">
    
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <div>
                <nav class="breadcrumb" aria-label="breadcrumb">
                    <ol class="flex text-sm">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}" class="text-primary hover:text-primary-dark">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('petani.index') }}" class="text-primary hover:text-primary-dark">Data Petani</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Edit Data</li>
                    </ol>
                </nav>
                <h2 class="font-semibold text-2xl text-gray-800 leading-tight mt-2">
                    {{ __('Edit Data Petani') }}
                </h2>
            </div>
            <a href="{{ route('petani.index') }}" class="btn btn-outline flex items-center gap-2">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                </svg>
                Kembali
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="card fade-in">
                <div class="card-header">
                    <h3 class="text-lg font-medium text-gray-800">Form Edit Data Petani</h3>
                    <p class="text-sm text-gray-500">Silakan edit data yang diperlukan</p>
                </div>
                <div class="card-body">
                    <form action="{{ route('petani.update', $petani->id) }}" method="POST" id="petaniForm">
                        @csrf
                        @method('PUT')
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div class="form-group">
                                <label for="nama_penyuluh" class="form-label">Nama</label>
                                <input type="text" name="nama_penyuluh" id="nama_penyuluh" value="{{ old('nama_penyuluh', $petani->nama_penyuluh) }}" 
                                    class="form-control @error('nama_penyuluh') border-red-500 @enderror" required>
                                @error('nama_penyuluh')
                                    <p class="text-danger text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="no_ktp" class="form-label">No KTP</label>
                                <input type="text" name="no_ktp" id="no_ktp" value="{{ old('no_ktp', $petani->no_ktp) }}" 
                                    class="form-control @error('no_ktp') border-red-500 @enderror" required>
                                @error('no_ktp')
                                    <p class="text-danger text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="nama_ibu_kandung" class="form-label">Nama Ibu Kandung</label>
                                <input type="text" name="nama_ibu_kandung" id="nama_ibu_kandung" value="{{ old('nama_ibu_kandung', $petani->nama_ibu_kandung) }}" 
                                    class="form-control @error('nama_ibu_kandung') border-red-500 @enderror" required>
                                @error('nama_ibu_kandung')
                                    <p class="text-danger text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="kode_desa" class="form-label">Desa</label>
                                <select name="kode_desa" id="kode_desa" 
                                    class="form-select @error('kode_desa') border-red-500 @enderror" required>
                                    <option value="">Pilih Desa</option>
                                    @foreach($desas as $desa)
                                        <option value="{{ $desa->kode_desa }}" {{ old('kode_desa', $petani->kode_desa) == $desa->kode_desa ? 'selected' : '' }}>{{ $desa->nama_desa }}</option>
                                    @endforeach
                                </select>
                                @error('kode_desa')
                                    <p class="text-danger text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="id_poktan" class="form-label">Kelompok Tani</label>
                                <select name="id_poktan" id="id_poktan" 
                                    class="form-select @error('id_poktan') border-red-500 @enderror" required>
                                    <option value="">Pilih Kelompok Tani</option>
                                    @foreach($poktans as $poktan)
                                        <option value="{{ $poktan->id_poktan }}" {{ old('id_poktan', $petani->id_poktan) == $poktan->id_poktan ? 'selected' : '' }}>{{ $poktan->nama_poktan }}</option>
                                    @endforeach
                                </select>
                                @error('id_poktan')
                                    <p class="text-danger text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="kode_kios" class="form-label">Kios</label>
                                <select name="kode_kios" id="kode_kios" 
                                    class="form-select @error('kode_kios') border-red-500 @enderror" required>
                                    <option value="">Pilih Kios</option>
                                    @foreach($kioss as $kios)
                                        <option value="{{ $kios->kode_kios }}" {{ old('kode_kios', $petani->kode_kios) == $kios->kode_kios ? 'selected' : '' }}>{{ $kios->nama_kios }}</option>
                                    @endforeach
                                </select>
                                @error('kode_kios')
                                    <p class="text-danger text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="subsektor" class="form-label">Subsektor (Opsional)</label>
                                <select name="subsektor" id="subsektor" 
                                    class="form-select @error('subsektor') border-red-500 @enderror">
                                    <option value="">Pilih Subsektor</option>
                                    <option value="tanaman_pangan" {{ old('subsektor', $petani->subsektor) == 'tanaman_pangan' ? 'selected' : '' }}>Tanaman Pangan</option>
                                    <option value="hortikultura" {{ old('subsektor', $petani->subsektor) == 'hortikultura' ? 'selected' : '' }}>Hortikultura</option>
                                    <option value="perkebunan" {{ old('subsektor', $petani->subsektor) == 'perkebunan' ? 'selected' : '' }}>Perkebunan</option>
                                    <option value="peternakan" {{ old('subsektor', $petani->subsektor) == 'peternakan' ? 'selected' : '' }}>Peternakan</option>
                                </select>
                                @error('subsektor')
                                    <p class="text-danger text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="komoditas" class="form-label">Komoditas (Opsional)</label>
                                <input type="text" name="komoditas" id="komoditas" value="{{ old('komoditas', $petani->komoditas) }}" 
                                    class="form-control @error('komoditas') border-red-500 @enderror">
                                @error('komoditas')
                                    <p class="text-danger text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="luas_lahan" class="form-label">Luas Lahan (Ha)</label>
                                <input type="number" step="0.01" name="luas_lahan" id="luas_lahan" value="{{ old('luas_lahan', $petani->luas_lahan) }}" 
                                    class="form-control @error('luas_lahan') border-red-500 @enderror">
                                @error('luas_lahan')
                                    <p class="text-danger text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="status" class="form-label">Status</label>
                                <div class="flex gap-4 mt-2">
                                    <label class="inline-flex items-center">
                                        <input type="radio" name="status" value="belum_terinput" class="form-radio" {{ old('status', $petani->status) == 'belum_terinput' ? 'checked' : '' }}>
                                        <span class="ml-2">Belum Terinput</span>
                                    </label>
                                    <label class="inline-flex items-center">
                                        <input type="radio" name="status" value="sudah_terinput" class="form-radio" {{ old('status', $petani->status) == 'sudah_terinput' ? 'checked' : '' }}>
                                        <span class="ml-2">Sudah Terinput</span>
                                    </label>
                                </div>
                                @error('status')
                                    <p class="text-danger text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <!-- Notification Area -->
                        <div id="notificationArea" class="mb-4 hidden">
                            <div id="successNotification" class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4 hidden">
                                <div class="flex items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                    </svg>
                                    <p id="successMessage">Data berhasil diperbarui!</p>
                                </div>
                            </div>
                            <div id="errorNotification" class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 hidden">
                                <div class="flex items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                                    </svg>
                                    <div>
                                        <p id="errorTitle" class="font-bold">Terjadi kesalahan!</p>
                                        <p id="errorMessage">Gagal memperbarui data. Silakan coba lagi.</p>
                                    </div>
                                </div>
                                <div class="mt-3">
                                    <button id="retryButton" class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded text-sm">
                                        Coba Lagi
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="form-actions mt-6 flex justify-end">
                            <button type="button" class="btn btn-outline mr-2" onclick="window.location.href='{{ route('petani.index') }}'">
                                Batal
                            </button>
                            <button type="submit" class="btn btn-primary flex items-center gap-2" id="submitBtn">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-3m-1 4l-3 3m0 0l-3-3m3 3V4" />
                                </svg>
                                <span>Simpan Perubahan</span>
                                <span class="loading-spinner hidden ml-2"></span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Form validation
            const form = document.getElementById('petaniForm');
            const submitBtn = document.getElementById('submitBtn');
            const btnText = submitBtn.querySelector('span:first-child');
            const loadingSpinner = submitBtn.querySelector('.loading-spinner');
            const notificationArea = document.getElementById('notificationArea');
            const successNotification = document.getElementById('successNotification');
            const errorNotification = document.getElementById('errorNotification');
            const retryButton = document.getElementById('retryButton');
            
            // Check for flash messages
            @if(session('error'))
                showError("{{ session('error') }}");
            @endif
            
            @if(session('success'))
                showSuccess("{{ session('success') }}");
            @endif
            
            form.addEventListener('submit', function(e) {
                // Basic client-side validation
                const noKtp = document.getElementById('no_ktp').value;
                if (noKtp.length !== 16 || isNaN(noKtp)) {
                    e.preventDefault();
                    showError("Nomor KTP harus 16 digit angka");
                    return false;
                }
                
                // Show loading state
                btnText.textContent = 'Menyimpan...';
                loadingSpinner.classList.remove('hidden');
                submitBtn.disabled = true;
            });
            
            // Retry button functionality
            retryButton.addEventListener('click', function() {
                errorNotification.classList.add('hidden');
                submitBtn.disabled = false;
                btnText.textContent = 'Simpan Perubahan';
                loadingSpinner.classList.add('hidden');
            });
            
            // Function to show error notification
            function showError(message, title = "Terjadi kesalahan!") {
                notificationArea.classList.remove('hidden');
                successNotification.classList.add('hidden');
                errorNotification.classList.remove('hidden');
                document.getElementById('errorTitle').textContent = title;
                document.getElementById('errorMessage').textContent = message;
            }
            
            // Function to show success notification
            function showSuccess(message) {
                notificationArea.classList.remove('hidden');
                errorNotification.classList.add('hidden');
                successNotification.classList.remove('hidden');
                document.getElementById('successMessage').textContent = message;
            }
            
            // Form input animation
            const formInputs = document.querySelectorAll('.form-control, .form-select');
            
            formInputs.forEach(input => {
                input.addEventListener('focus', function() {
                    this.parentElement.classList.add('focused');
                });
                
                input.addEventListener('blur', function() {
                    this.parentElement.classList.remove('focused');
                });
            });
        });
    </script>
</x-app-layout>