<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Edit Kelompok Tani') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <form method="POST" action="{{ route('poktan.update', $poktan->id_poktan) }}">
                        @csrf
                        @method('PUT')

                        <div class="mb-4">
                            <x-input-label for="id_poktan" :value="__('ID Poktan')" />
                            <x-text-input id="id_poktan" class="block mt-1 w-full bg-gray-100" type="text" name="id_poktan" :value="$poktan->id_poktan" required readonly />
                            <x-input-error :messages="$errors->get('id_poktan')" class="mt-2" />
                        </div>

                        <div class="mb-4">
                            <x-input-label for="nama_poktan" :value="__('Nama Kelompok Tani')" />
                            <x-text-input id="nama_poktan" class="block mt-1 w-full" type="text" name="nama_poktan" :value="$poktan->nama_poktan" required />
                            <x-input-error :messages="$errors->get('nama_poktan')" class="mt-2" />
                        </div>

                        <div class="mb-4">
                            <x-input-label for="kode_desa" :value="__('Desa')" />
                            <select id="kode_desa" name="kode_desa" class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full" required>
                                <option value="">Pilih Desa</option>
                                @foreach ($desas as $desa)
                                    <option value="{{ $desa->kode_desa }}" {{ $poktan->kode_desa == $desa->kode_desa ? 'selected' : '' }}>
                                        {{ $desa->nama_desa }}
                                    </option>
                                @endforeach
                            </select>
                            <x-input-error :messages="$errors->get('kode_desa')" class="mt-2" />
                        </div>

                        <div class="flex items-center justify-end mt-4">
                            <a href="{{ route('poktan.index') }}" class="inline-flex items-center px-4 py-2 bg-gray-300 border border-transparent rounded-md font-semibold text-xs text-gray-700 uppercase tracking-widest hover:bg-gray-400 focus:bg-gray-400 active:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2 transition ease-in-out duration-150 mr-2">
                                Batal
                            </a>
                            <x-primary-button>
                                {{ __('Simpan') }}
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>