<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\DesaController;
use App\Http\Controllers\PoktanController;
use App\Http\Controllers\KiosController;
use App\Http\Controllers\PetaniController;
use App\Http\Controllers\DashboardController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', [DashboardController::class, 'index'])->middleware(['auth', 'verified'])->name('dashboard');
Route::get('/dashboard/stats', [DashboardController::class, 'getStats'])->middleware(['auth', 'verified'])->name('dashboard.stats');

Route::middleware(['auth', 'verified'])->group(function () {
    // Master Data Routes
    Route::resource('desa', DesaController::class);
    Route::resource('poktan', PoktanController::class);
    Route::resource('kios', KiosController::class);
    
    // Poktan Export/Import Routes
    Route::get('/poktan-export', [PoktanController::class, 'export'])
        ->name('poktan.export')
        ->middleware('throttle:5,1'); // 5 requests per minute
    Route::post('/poktan-import', [PoktanController::class, 'import'])
        ->name('poktan.import')
        ->middleware('throttle:3,1'); // 3 requests per minute
    Route::get('/poktan-template', [PoktanController::class, 'downloadTemplate'])
        ->name('poktan.template')
        ->middleware('throttle:10,1'); // 10 requests per minute
    
    // Endpoint JSON: daftar poktan berdasarkan desa
    Route::get('/api/poktans-by-desa/{kode_desa}', [PoktanController::class, 'byDesa'])
        ->name('poktan.byDesa')
        ->middleware(['throttle:30,1']);
    
    // Petani Routes dengan rate limiting untuk operasi sensitif
    Route::resource('petani', PetaniController::class);
    Route::get('/petani-export', [PetaniController::class, 'export'])
        ->name('petani.export')
        ->middleware('throttle:5,1'); // 5 requests per minute
    Route::post('/petani-import', [PetaniController::class, 'import'])
        ->name('petani.import')
        ->middleware('throttle:3,1'); // 3 requests per minute
    
    // User Management Routes (Admin Only)
    Route::middleware(['admin'])->group(function () {
        Route::resource('user', UserController::class);
    });
    
    // Profile Routes
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';
